/*
 Standalone Temperature Reader for Arduino
 Version: 1.1
 Author: electricteardown (http://www.insidegadgets.com)
 Created: 9/01/2011
 Last Modified: 7/02/2011
 
 Use on the Arduino to take the data out from the ATtiny85 EEPROM and 
 print to Arduino program's serial monitor (or any other serial enabled
 program).
 
 */

int clockPin = 2;
int dataPin = 0; // Analog input 0

boolean inTransfer = true;

void setup() {
  pinMode(clockPin, OUTPUT);
  pinMode(13, OUTPUT); 
  Serial.begin(9600);
}

void loop() {
  digitalWrite(clockPin, LOW);
  delay(50);
  digitalWrite(clockPin, HIGH);
  Serial.println("Ready");
  
  boolean dataReady = false;
  int datainCount = 0;
  while (dataReady == false) {
    delay(25);
    int dataIn = analogRead(dataPin);
    if (dataIn >= 350) {
      datainCount++;
    }
    else {
      datainCount = 0;
    }
    if (datainCount >= 9) { // At least 225ms high, get ready
      dataReady = true;
      digitalWrite(13, HIGH);
      while (dataIn >= 350) { // Wait for data low
        dataIn = analogRead(dataPin);
      }
    }  
  } 
  
  while (inTransfer == true) {
    byte dataByte = 0;
    for (int x = 7; x >= 0; x--) {
      digitalWrite(clockPin, HIGH);
      delay(1);
      digitalWrite(clockPin, LOW);
      delay(1);
      int dataIn = analogRead(dataPin);
      if (dataIn >= 350) {
        bitWrite(dataByte, x, HIGH); // Write the bit received to dataByte
        Serial.print("1");
      }
      else {
        Serial.print("0");
      }
    }
    if (dataByte == 0) { // Received 00000000, we are done reading
      inTransfer = false;
    }
    else {
      Serial.print(" = ");
      Serial.print((dataByte-130), DEC); // Convert to real temp
      Serial.println();
    }
  }  
  
  digitalWrite(clockPin, LOW);
  digitalWrite(13, LOW);
  while (1);
}

