/*
 ATtiny25/45/85 Blink 32KHz
 Version: 1.0
 Author: Alex from Inside Gadgets (http://www.insidegadgets.com)
 Created: 2/010/2011
 Last Modified: 2/10/2011
 
 Blink an LED on the ATtiny25/45/85 using the timer every 1 second with a 32.768 KHz watch crystal then go to IDLE sleep.
 
 */

#define F_CPU 32768 // 32.768 KHz clock

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>
#include "setup.c"

// ATtiny25/45/85 Pin map
//                        +-\/-+
// Reset/Ain0 (D 5) PB5  1|o   |8  Vcc
//       Ain3 (D 3) PB3  2|    |7  PB2 (D 2) Ain1
//       Ain2 (D 4) PB4  3|    |6  PB1 (D 1) pwm1
//                  GND  4|    |5  PB0 (D 0) pwm0 <-- connect resistor and LED here
//                        +----+

#define ledPin PB0

volatile boolean led_state = 0; // LED state on/off variable

int main(void) {
	
	setup();
	
	DDRB = (1<<ledPin); // Set LED as an output
	PORTB |= ((1<<PB2) | (1<<PB1)); // Turn on pull-up resistors on other ports to save power
	
	while(1) {
		
		if (led_state == 1) { 
			PORTB |= (1<<ledPin); // Turn on LED
		}
		else { 
			PORTB &= ~(1<<ledPin); // Turn off LED
		}
		
		set_sleep_mode(SLEEP_MODE_IDLE); // Set sleep mode as idle
		sleep_mode(); // System sleeps here		
	}
}

// Timer 1 interrupt
ISR(TIMER1_OVF_vect) {
	led_state = !led_state; // Change led state to be the opposite of what it is
}
