/*
 ATtiny25/45/85 Blink 32KHz
 Version: 1.0
 Author: Alex from Inside Gadgets (http://www.insidegadgets.com)
 Created: 2/010/2011
 Last Modified: 2/10/2011
 
 Blink an LED on the ATtiny25/45/85 using the timer every 1 second with a 32.768 KHz watch crystal then go to IDLE sleep.
 
 */
 
#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif
#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif

#ifndef boolean
	typedef uint8_t boolean;
#endif 

// Used from Arduino wiring.c - to setup the ATtiny
void setup(void) {
	sei(); // Turn on interrupts
	
	// Set prescaler to 128 to give exactly 1 second before an overflow occurs.
	// 128 prescaler x 256 timer bits / 32768 clock = 1 second
	sbi(TCCR1, CS13);
	
	// Enable timer 1 overflow interrupt
	sbi(TIMSK, TOIE1); 

}
