
// ATtiny10 Pin map
//        +-\/-+
//  PB0  1|o   |6  Reset
//  GND  2|    |5  Vcc
//  PB1  3|    |4  PB2
//        +----+

#define T16MS 0
#define T32MS 1
#define T64MS 2
#define T128MS 3
#define T250MS 4
#define T500MS 5
#define T1S 6
#define T2S 7
#define T4S 8
#define T8S 9

#undef F_CPU
#define F_CPU 1000000UL
#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif
#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif

#include <avr/io.h>
#include <avr/sleep.h>
#include <util/delay.h>

void system_sleep(void) {
	set_sleep_mode(SLEEP_MODE_PWR_DOWN); // Set sleep mode
	sleep_mode(); // System sleeps here
}

// Watchdog timeout values
// 0=16ms, 1=32ms, 2=64ms, 3=128ms, 4=250ms, 5=500ms, 6=1sec, 7=2sec, 8=4sec, 9=8sec
// Used from http://interface.khm.de/index.php/lab/experiments/sleep_watchdog_battery/
void setup_watchdog(uint8_t ii) {
	uint8_t bb;
	if (ii > 9 ) ii=9;
	bb=ii & 7;
	if (ii > 7) bb|= (1<<5);
	bb |= (1<<WDIE);
	bb &= ~(1<<WDE);
	
	RSTFLR &= ~(1<<WDRF);
	// Set new watchdog timeout value and start timed sequence
	WDTCSR = bb;
}

// Turn off the Watchdog
void turnOffwatchdog(void) {
	asm("cli");// Turn interrupts off
	RSTFLR &= ~(1<<WDRF);
	WDTCSR &= ~((1<<WDIE) | (1<<WDE));
	asm("sei"); // Turn interrupts back on
}

int main(void) {
	asm("sei");
	DDRB |= (1 << PB0);
	
	while(1) {
		setup_watchdog(T1S);
		system_sleep();
		//while(1) { asm("nop"); }
		turnOffwatchdog();
	}
}

void WDT_timeout(void) {
	PORTB ^= (1 << PB0); 
}

	