/*
 ATtiny85 with CY22150
 Version: 1.0
 Author: Alex from insideGadgets (www.insidegadgets.com)
 Created: 17/02/2014
 Last Modified: 17/02/2014
 
 Testing the Cypress CY22150 Programmable Clock Generator with the ATtiny85
 
 */
 
// ATtiny25/45/85 Pin map
//                    +-\/-+
//        Reset PB5  1|o   |8  VCC
//          SCL PB3  2|    |7  PB2 LED
//              PB4  3|    |6  PB1 
//              GND  4|    |5  PB0 SDA
//                    +----+

#define F_CPU 1000000

#define TWI_SDA_PIN PB0
#define TWI_SCL_PIN PB3

#define ledPin (1<<PB2)
#define DEVICE_ADDR 0x69

#include <avr/io.h>
#include <util/delay.h>
#include "setup.c"

int main(void) {
	DDRB |= ledPin;
	_delay_ms(1000);
	
	SoftI2cMasterInit(); // Initialise I2C
	
	// General crystal setup and output enable
	soft_i2c_write_byte(DEVICE_ADDR, 0x12, 48); // 16 MHz, 60 ohm ESR
	soft_i2c_write_byte(DEVICE_ADDR, 0x13, 107); // Crystal capacitance control for 18pF crystal
	soft_i2c_write_byte(DEVICE_ADDR, 0x09, 1); // Enable LCLK_1 output
	
	// 133 MHz
	soft_i2c_write_byte(DEVICE_ADDR, 0x0C, 6); // Select VCO with 6 divider (For fixed /3 divider option, set DIV1N to 6)
	soft_i2c_write_byte(DEVICE_ADDR, 0x44, 96); // LCLK_1 set to DIV1CLK/3
	soft_i2c_write_byte(DEVICE_ADDR, 0x42, 142); // PO = 1 and Q = 16 (14 value + 2)
	soft_i2c_write_byte(DEVICE_ADDR, 0x40, 196); // Charge pump = 2 (P total = 45  479)
	soft_i2c_write_byte(DEVICE_ADDR, 0x41, 195); // PB value = 195 (for Ptotal 399)
	
	// 50 MHz
	/*soft_i2c_write_byte(DEVICE_ADDR, 0x0C, 8); // VCO with 8 divider
	soft_i2c_write_byte(DEVICE_ADDR, 0x44, 32); // LCLK_1 set to DIV1CLK/DIV1N.
	soft_i2c_write_byte(DEVICE_ADDR, 0x42, 0); // Q = 2 (0 value + 2)
	soft_i2c_write_byte(DEVICE_ADDR, 0x40, 196); // Charge pump = 2 (P total = 45  479)
	soft_i2c_write_byte(DEVICE_ADDR, 0x41, 21); // PB value = 21 (for Ptotal 50)
	*/
	
	PORTB |= ledPin;
	while(1);
	
	return 0;
}

