/*
 ATtiny13/25 Audio Switcher
 Version: 1.0
 Author: Alex from insideGadgets (www.insidegadgets.com)
 Created: 12/11/2014
 Last Modified: 12/11/2014
 
 */

// ATtiny13/25 Pin map
//
//                      +-\/-+
//          Reset PB5  1|o   |8  VCC
//    Desk Switch PB3  2|    |7  PB2 Desk LED
//  iPhone Switch PB4  3|    |6  PB1 iPhone LED
//                GND  4|    |5  PB0 Analog switch select
//                      +----+

#define F_CPU 1000000 // 1 MHz clock

#include <avr/io.h>
#include <avr/wdt.h>
#include <avr/eeprom.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/sleep.h>
#include <math.h>
#include <util/delay.h>
#include <string.h>
#include "setup.c"

int main(void) {
	setup();
	
	// On power up blink the LED 3 times
	for (int x = 0; x < 3; x++) {
		PORTB |= (1<<LED1_IPHONE) | (1<<LED2_DESK);
		_delay_ms(100);
		PORTB &= ~((1<<LED1_IPHONE) | (1<<LED2_DESK));
		_delay_ms(100);
	}
	
	while(1) {
		system_sleep();
		_delay_ms(50); // Wait for button debounce
		
		if (PINB & (1<<SW1_IPHONE)) { // Change to iPhone
			PORTB |= (1<<LED1_IPHONE);
			PORTB &= ~(1<<LED2_DESK);
			
			PORTB |= (1<<ANA_SW_SELECT); // Change switch high
		}
		else if (PINB & (1<<SW2_DESK)) { // Change to Desk phone
			PORTB |= (1<<LED2_DESK);
			PORTB &= ~(1<<LED1_IPHONE);
			
			PORTB &= ~(1<<ANA_SW_SELECT); // Change switch low
		}
	}
}

// Pin interrupt on switches
ISR(PCINT0_vect) { }
