/*
 ATtiny13/25 Audio Switcher
 Version: 1.0
 Author: Alex from insideGadgets (www.insidegadgets.com)
 Created: 12/11/2014
 Last Modified: 12/11/2014

 */

#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif
#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif

#ifndef boolean
	typedef uint8_t boolean;
#endif
#ifndef bool
	typedef uint8_t bool;
#endif 
#ifndef byte
	typedef uint8_t byte;
#endif

#ifndef NULL
#define NULL ((void *)0)
#endif

#define LOW 0
#define HIGH 1
#define false 0
#define true 1

#define SW1_IPHONE PB4
#define SW2_DESK PB3
#define LED1_IPHONE PB1
#define LED2_DESK PB2
#define ANA_SW_SELECT PB0

// Sleep - powerdown
void system_sleep(void) {
	set_sleep_mode(SLEEP_MODE_PWR_DOWN); // Set sleep mode
	sleep_mode(); // System sleeps here
}

// Setup the AVR
void setup(void) {
	// Set outputs
	DDRB |= (1<<LED1_IPHONE) | (1<<LED2_DESK) | (1<<ANA_SW_SELECT);
	
	// Pin interrupt setup
	sbi(GIMSK,PCIE); // Enable pin change interrupt
	sbi(PCMSK,PCINT3); // Buttons
	sbi(PCMSK,PCINT4);
	
	// Turn on interrupt
	sei();
}
