/*
 10x 8x8 LED Clock
 Version: 1.0
 Author: Alex from insideGadgets (http://www.insidegadgets.com)
 Created: 11/03/2015
 Last Modified: 25/06/2015
 
 */
 
#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif
#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif

#ifndef boolean
	typedef uint8_t boolean;
#endif
#ifndef bool
	typedef uint8_t bool;
#endif 
#ifndef byte
	typedef uint8_t byte;
#endif

#ifndef NULL
#define NULL ((void *)0)
#endif

#define LOW 0
#define HIGH 1
#define false 0
#define true 1

#define start_time 0
#define end_time 1
#define delay_time 2
#define start_location 4
#define end_location 3
#define animation_speed 5
#define display_type 6

#define A 0
#define B 1
#define C 2
#define D 3
#define E 4
#define F 5
#define G 6
#define H 7
#define I 8
#define J 9
#define K 10
#define L 11
#define M 12
#define N 13
#define O 14
#define P 15
#define Q 16
#define R 17
#define S 18
#define T 19
#define U 20
#define V 21
#define W 22
#define X 23
#define Y 24
#define Z 25
#define BK 26
#define NO0 30
#define NO1 31
#define NO2 32
#define NO3 33
#define NO4 34
#define NO5 35
#define NO6 36
#define NO7 37
#define NO8 38
#define NO9 39
#define COLON 40

#define NOREPEATSTART 0
#define REPEATSTART 1

#define I2C_DELAY_CYCLES 4
#define I2C_READ 1
#define I2C_WRITE 0

// Soft I2c Library used from http://forums.adafruit.com/viewtopic.php?f=25&t=13722
// Initialize SCL/SDA pin and set the bus high
void SoftI2cMasterInit(void) {
	DDRC |= (1<<TWI_SDA_PIN);
	PORTC |= (1<<TWI_SDA_PIN);
	DDRC |= (1<<TWI_SCL_PIN);
	PORTC |= (1<<TWI_SCL_PIN);
}

// De-initialize SCL/SDA pins and set the bus low
void SoftI2cMasterDeInit(void) {
	PORTC &= ~(1<<TWI_SDA_PIN);
	DDRC &= ~(1<<TWI_SDA_PIN);
	PORTC &= ~(1<<TWI_SCL_PIN);
	// Don't re-set the clock to an input
}

// Read a byte from I2C and send Ack if more reads follow else Nak to terminate read
uint8_t SoftI2cMasterRead(uint8_t last) {
	uint8_t b = 0;
	// Make sure pull-up enabled
	PORTC |= (1<<TWI_SDA_PIN);
	DDRC &= ~(1<<TWI_SDA_PIN);
	// Read byte
	for (uint8_t i = 0; i < 8; i++) {
		// Don't change this loop unless you verify the change with a scope
		b <<= 1;
		_delay_loop_1(I2C_DELAY_CYCLES);
		PORTC |= (1<<TWI_SCL_PIN);
		_delay_loop_1(I2C_DELAY_CYCLES);
		if (bit_is_set(PINC, TWI_SDA_PIN)) b |= 1;
		_delay_loop_1(I2C_DELAY_CYCLES);
		PORTC &= ~(1<<TWI_SCL_PIN);
	}
	_delay_loop_1(I2C_DELAY_CYCLES);
	
	// Send Ack or Nak
	DDRC |= (1<<TWI_SDA_PIN);
	if (last) { 
		PORTC |= (1<<TWI_SDA_PIN); 
	}
	else { 
		PORTC &= ~(1<<TWI_SDA_PIN);
	}
	PORTC |= (1<<TWI_SCL_PIN);
	_delay_loop_1(I2C_DELAY_CYCLES);
	PORTC &= ~(1<<TWI_SCL_PIN);
	PORTC &= ~(1<<TWI_SDA_PIN);
	return b;
}

// Write a byte to I2C
uint8_t SoftI2cMasterWrite(uint8_t data) {
	// Write byte
	for (uint8_t m = 0x80; m != 0; m >>= 1) {
		// Don't change this loop unless you verify the change with a scope
		if (m & data) { 
			PORTC |= (1<<TWI_SDA_PIN); 
		}
		else { 
			PORTC &= ~(1<<TWI_SDA_PIN); 
		}
		PORTC |= (1<<TWI_SCL_PIN);
		_delay_loop_1(I2C_DELAY_CYCLES);
		PORTC &= ~(1<<TWI_SCL_PIN);
		_delay_loop_1(I2C_DELAY_CYCLES);
	}
	// get Ack or Nak
	DDRC &= ~(1<<TWI_SDA_PIN);
	// Enable pullup
	PORTC |= (1<<TWI_SDA_PIN);
	PORTC |= (1<<TWI_SCL_PIN);
	_delay_loop_1(I2C_DELAY_CYCLES);
	uint8_t rtn = bit_is_set(PINC, TWI_SDA_PIN);
	PORTC &= ~(1<<TWI_SCL_PIN);
	PORTC &= ~(1<<TWI_SDA_PIN);
	DDRC |= (1<<TWI_SDA_PIN);
	return rtn == 0;
}

// Issue a start condition
uint8_t SoftI2cMasterStart(uint8_t addressRW) {
	PORTC &= ~(1<<TWI_SDA_PIN);
	_delay_loop_1(I2C_DELAY_CYCLES);
	PORTC &= ~(1<<TWI_SCL_PIN);
	return SoftI2cMasterWrite(addressRW);
}

// Issue a restart condition
uint8_t SoftI2cMasterRestart(uint8_t addressRW) {
	PORTC |= (1<<TWI_SDA_PIN);
	PORTC |= (1<<TWI_SCL_PIN);
	_delay_loop_1(I2C_DELAY_CYCLES);
	return SoftI2cMasterStart(addressRW);
}

// Issue a stop condition
void SoftI2cMasterStop(void) {
	PORTC &= ~(1<<TWI_SDA_PIN);
	_delay_loop_1(I2C_DELAY_CYCLES);
	PORTC |= (1<<TWI_SCL_PIN);
	_delay_loop_1(I2C_DELAY_CYCLES);
	PORTC |= (1<<TWI_SDA_PIN);
	_delay_loop_1(I2C_DELAY_CYCLES);
}

// Issue the device start and the address to write
uint8_t SoftI2cMasterAddress(uint8_t deviceAddr, uint8_t addressRW, uint8_t repeatedStart) {
	if (!SoftI2cMasterStart((deviceAddr<<1) | I2C_WRITE)) return false;
	if (!SoftI2cMasterWrite(addressRW)) return false;
	if (repeatedStart) { if (!SoftI2cMasterRestart((deviceAddr<<1) | I2C_READ)) return false; }
	
	return true;
}

// Text array
PROGMEM const uint8_t ledLetters[][8] = {
	{24,8,20,20,20,28,34,119}, // A
	{124,34,34,60,34,34,34,124}, // B
	{30,34,64,64,64,64,34,28}, // C
	{120,36,34,34,34,34,36,120},
	{126,34,40,56,40,32,34,126},
	{126,34,40,56,40,32,32,112},
	{30,34,64,64,71,66,34,28},
	{119,34,34,62,34,34,34,119},
	{62,8,8,8,8,8,8,62},
	{30,4,4,4,68,68,68,56},
	{119,34,36,40,56,36,34,115},
	{112,32,32,32,32,34,34,126},
	{119,54,54,42,42,34,34,119},
	{231,98,82,82,74,74,70,230},
	{28,34,65,65,65,65,34,28},
	{124,34,34,34,60,32,32,112}, // P
	{28,34,65,65,65,77,34,29},
	{124,34,34,34,60,36,34,113},
	{58,70,64,60,2,2,98,92},
	{127,73,8,8,8,8,8,28},
	{119,34,34,34,34,34,34,28},
	{231,66,66,36,36,36,24,24},
	{119,34,34,42,42,42,42,20},
	{119,34,20,8,8,20,34,119},
	{119,34,20,20,8,8,8,28},
	{62,34,4,8,8,16,34,62}, // Z
	{0,0,0,0,0,0,0,0}, // Blank
	{16,16,16,16,16,0,0,16}, // !
	{56,68,4,4,8,16,0,48}, // ?
	{0,0,0,0,0,0,24,24}, // .
	{60,66,66,66,66,66,66,60}, // 0
	{8,56,8,8,8,8,8,62}, // 1
	{56,68,4,8,16,32,68,124}, // 2
	{56,68,4,24,4,4,68,56},
	{12,20,36,36,126,4,4,14},
	{62,32,32,60,2,2,66,60}, // 5
	{14,16,32,60,34,34,34,28},
	{126,66,2,4,4,8,8,8},
	{60,66,66,60,66,66,66,60},
	{60,66,66,66,62,2,4,120}, // 9
	{0,24,24,0,0,24,24,0}, // :
	
};

// Setup the MCU
void setup(void) {
	// Increase clock speed to 8MHz
	CLKPR = (1<<CLKPCE); // Prescaler enable
	CLKPR = 0; 
	
	_delay_ms(500); // Wait a little bit after power on
	
	// Configure outputs
	DDRC |= ((1<<PC2) | (1<<PC1) | (1<<PC0));
	DDRD |= 255;
	
	// Init I2c
	SoftI2cMasterInit();
	
	// Init Timer
	TCNT0 = 0; // Reset to 0
	TCCR0A = (1<<WGM01);
	TCCR0B = ((1<<CS02) | (1<<CS00)); // 256 prescaler
	sbi(TIMSK0, OCIE0A); // Enable overflow interrupt
	OCR0A = 125;
	
	sei(); // Turn on interrupts
}
