/*
 Wireless Gameboy/GBA Controller - Super Nintendo RX
 Version: 1.0
 Author: Alex from insideGadgets (http://www.insidegadgets.com)
 Created: 3/10/2018
 Last Modified: 1/01/2019
 
 */

#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif
#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif

#ifndef NULL
#define NULL ((void *)0)
#endif

#define LOW 0
#define HIGH 1
#define false 0
#define true 1

#define LED PA2
#define CLK PA0
#define DATA PA1
#define LATCH PB2

#define GB_MODE 1
#define GBA_MODE 2

// nRF settings (loaded from EEPROM)
uint8_t nrfChannel = 0;
uint8_t nrfRx[5] = "wgbr"; // Last byte loaded from EEPROM

// EEPROM settings
#define nrfChannelLocation 1
#define nrfRxLocation 2
#define blankEEPROMByte 255


extern void mirf_init(void);
extern void mirf_config(void);

// SPI transfer 1 byte and return the result
uint8_t spi_transfer(uint8_t data) {
	SPDR = data;
	
	// Wait for transmission complete
	while (!(SPSR & (1<<SPIF)));
	
	return SPDR;
}

// Write data using SPI
void spi_write_data(uint8_t * dataout, uint8_t len) {
	uint8_t i;
	for (i = 0; i < len; i++) {
		spi_transfer(dataout[i]);
	}
}

// Read data using SPI
void spi_read_data(uint8_t * datain, uint8_t len) {
	uint8_t i;
	for (i = 0; i < len; i++) {
		datain[i] = spi_transfer(0x00);
	}
}

// Initialise the SPI
void spi_init(void) {
	DDRA |= (1<<PA4); // SPI CLK
	DDRA &= ~(1<<PA5); // SPI DI
	PORTA |= (1<<PA5); // SPI DI
	DDRA |= (1<<PA6); // SPI DO
	DDRA |= (1<<PA7); // SPI SS
	
	// Enable SPI, Master, set clock rate fck/4
	SPCR = (1<<SPE)|(1<<MSTR);
}

// Setup
void setup(void) {
	DDRA |= (1<<DATA);
	PORTA &= ~(1<<DATA);
	
	DDRA |= (1<<LED);
	PORTA |= (1<<LED);
	_delay_ms(250); // Wait a little bit after power on
	PORTA &= ~(1<<LED);
	
	// Load nRF channel and address from EEPROM
	nrfChannel = eeprom_read_byte((uint8_t*) nrfChannelLocation);
	nrfRx[4] = eeprom_read_byte((uint8_t*) nrfRxLocation);
	if (nrfChannel == blankEEPROMByte) {
		nrfChannel = 1;
		nrfRx[4] = 1;
	}
	
	spi_init(); // Initialise SPI
	sei(); // Turn on interrupts
	
	mirf_init();
	_delay_ms(50);
	mirf_config();
}
